/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.components.AttachedLightSourceComponent;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.AttachedEntity;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class LocationComponent
implements EntityComponent {
    private Vector2 worldPosition;
    private Vector2 facing = new Vector2();
    private EntityAssetOrientation orientation;
    private float radius = 0.3f;
    private Vector2 linearVelocity = new Vector2();
    private float maxLinearSpeed = 1.8f;
    private float maxLinearAcceleration = 1.2f;
    private float angularVelocity = 0.0f;
    private float maxAngularSpeed = 5.0f;
    private float maxAngularAcceleration = 1.0f;
    private float rotation;
    private Entity parentEntity;
    private boolean isSlowed = false;

    public void init(Entity parentEntity) {
        this.parentEntity = parentEntity;
    }

    @Override
    public LocationComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        LocationComponent cloned = new LocationComponent();
        if (this.worldPosition != null) {
            cloned.worldPosition = this.worldPosition.cpy();
        }
        cloned.facing = this.facing.cpy();
        cloned.orientation = this.orientation;
        cloned.radius = this.radius;
        cloned.linearVelocity = this.linearVelocity.cpy();
        cloned.maxLinearSpeed = this.maxLinearSpeed;
        cloned.maxLinearAcceleration = this.maxLinearAcceleration;
        cloned.angularVelocity = this.angularVelocity;
        cloned.maxAngularSpeed = this.maxAngularSpeed;
        cloned.maxAngularAcceleration = this.maxAngularAcceleration;
        cloned.rotation = this.rotation;
        cloned.isSlowed = this.isSlowed;
        cloned.init(this.parentEntity);
        return cloned;
    }

    public Vector2 getWorldPosition() {
        return this.worldPosition;
    }

    public void setWorldPosition(Vector2 newPosition, boolean updateFacing) {
        AttachedLightSourceComponent attachedLightSourceComponent;
        if (this.worldPosition != null && updateFacing) {
            Vector2 previousPosition = this.worldPosition.cpy();
            Vector2 difference = newPosition.cpy().sub(previousPosition);
            this.setFacing(difference);
        }
        this.worldPosition = newPosition;
        if (this.parentEntity != null && (attachedLightSourceComponent = this.parentEntity.getComponent(AttachedLightSourceComponent.class)) != null) {
            attachedLightSourceComponent.updatePosition();
        }
    }

    public Vector2 getFacing() {
        return this.facing;
    }

    public void setFacing(Vector2 facing) {
        this.facing = facing.nor();
        this.setOrientation(EntityAssetOrientation.fromFacing(facing));
    }

    public void setOrientation(EntityAssetOrientation newOrientation) {
        this.orientation = newOrientation;
        if (this.parentEntity != null) {
            for (AttachedEntity attachedItem : this.parentEntity.getAttachedEntities()) {
                attachedItem.entity.getLocationComponent().setOrientation(newOrientation);
            }
            AttachedLightSourceComponent attachedLightSourceComponent = this.parentEntity.getComponent(AttachedLightSourceComponent.class);
            if (attachedLightSourceComponent != null) {
                attachedLightSourceComponent.updatePosition();
            }
        }
    }

    public EntityAssetOrientation getOrientation() {
        return this.orientation;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public Vector2 getLinearVelocity() {
        return this.linearVelocity;
    }

    public void setLinearVelocity(Vector2 linearVelocity) {
        this.linearVelocity = linearVelocity;
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(float angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public float getMaxLinearSpeed() {
        return this.maxLinearSpeed;
    }

    public void setMaxLinearSpeed(float maxLinearSpeed) {
        this.maxLinearSpeed = maxLinearSpeed;
    }

    public float getMaxLinearAcceleration() {
        return this.maxLinearAcceleration;
    }

    public void setMaxLinearAcceleration(float maxLinearAcceleration) {
        this.maxLinearAcceleration = maxLinearAcceleration;
    }

    public float getMaxAngularSpeed() {
        return this.maxAngularSpeed;
    }

    public void setMaxAngularSpeed(float maxAngularSpeed) {
        this.maxAngularSpeed = maxAngularSpeed;
    }

    public float getMaxAngularAcceleration() {
        return this.maxAngularAcceleration;
    }

    public void setMaxAngularAcceleration(float maxAngularAcceleration) {
        this.maxAngularAcceleration = maxAngularAcceleration;
    }

    public boolean isSlowed() {
        return this.isSlowed;
    }

    public void setSlowed(boolean slowed) {
        this.isSlowed = slowed;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }
}

